﻿using Microsoft.AspNet.Identity;
using PhotoApp.Models;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;
using System.Web;
using System.Web.Mvc;

namespace PhotoApp.Controllers
{
    [Authorize]
    public class ManagePhotosController : Controller
    {
        private ApplicationDbContext db = new ApplicationDbContext();
        // GET: ManagePhotos
        public ActionResult Index()
        {
            string userId = User.Identity.GetUserId();
            string path = Path.Combine(Server.MapPath("~/App_Data/Files"), "style.png");
            ViewBag.userId = userId;
            var data = db.Photos.ToList();
            return View(data);
        }
        public ActionResult AddPhotos()
        {
            //ViewBag.lstTags = new List<SelectListItem> {
            //    new SelectListItem{ Text="Home",Value="Home"},
            //    new SelectListItem{ Text="Friends",Value="Friends"},
            //    new SelectListItem{ Text="Festival",Value="Festival"},
            //    new SelectListItem{ Text="Personal",Value="Personal"},
            //    new SelectListItem{ Text="ProfilePics",Value="ProfilePics"},,,
            //};
            ViewBag.lstTags = db.TagMaster
            .Select(t => new SelectListItem
            {
                Text = t.TagName,
                Value = t.TagName
            })
            .ToList();
            return View();
        }
        [HttpPost]
        public ActionResult AddPhotos(Photos model)
        {
            if (ModelState.IsValid)
            {
                model.PhotosId = Guid.NewGuid();
                model.CreatedOn = DateTime.Now;
                db.Photos.Add(model);
                db.SaveChanges();
                return RedirectToAction("Index");
            } 
            return View();
           
        }
        [HttpPost]
        public ActionResult UploadFile(HttpPostedFileBase file,string TagName,string Details)
        {
            if (file != null && file.ContentLength > 0)
            {
                string folderPath = Server.MapPath("~/Files/");
                if (!Directory.Exists(folderPath))
                {
                    Directory.CreateDirectory(folderPath);
                }

                string filePath = Path.Combine(folderPath, Path.GetFileName(file.FileName));
                file.SaveAs(filePath);

                return Content("File uploaded successfully: "+TagName+" | "+ Details+"|" + file.FileName);
            }

            return Content("No file selected.");
        }
        [HttpPost]
        public ActionResult UploadFiles(IEnumerable<HttpPostedFileBase> files, string TagName, string Details)
        { 
            string userId = User.Identity.GetUserId();
            if (files != null && files.Any())
            {
                List<string> uploadedFiles = new List<string>();

                //Create Parent Directory
                string folderPath = Server.MapPath("~/App_Data/Files/" + userId);
                if (!Directory.Exists(folderPath))
                {
                    Directory.CreateDirectory(folderPath);
                }
                string folderPathPublic = Server.MapPath("~/Files/" + userId);
                if (!Directory.Exists(folderPathPublic))
                {
                    Directory.CreateDirectory(folderPathPublic);
                }
                //Create Parent Compressed Directory
                string folderPath_com = Server.MapPath("~/Files/" + userId + "");
                if (!Directory.Exists(folderPath_com))
                {
                    Directory.CreateDirectory(folderPath_com);
                }
                foreach (var file in files)
                {
                    if (file != null && file.ContentLength > 0)
                    {
                        Photos model = new Photos();
                        model.PhotosId = Guid.NewGuid();
                        model.CreatedOn = DateTime.Now;
                        string safeFileName = Regex.Replace(Path.GetFileName(file.FileName), @"[^a-zA-Z0-9_.-]", "_");
                        string FileUID = model.PhotosId + "_" + safeFileName;
                        //string filePath = Path.Combine(folderPath, Path.GetFileName(file.FileName));
                        string filePath = Path.Combine(folderPath, FileUID);
                        file.SaveAs(filePath);

                        // Compress & create thumbnail icon (64×64)
                        string FileUID_comp = "C" + FileUID;
                        string filepath_comp = Path.Combine(folderPath_com, FileUID_comp);
                        SaveThumbnailIcon(file, filepath_comp, 100, 100);

                        uploadedFiles.Add(FileUID);
                        model.OriginalImage = FileUID;
                        model.ShortImage = FileUID_comp;
                        model.TagName = TagName;
                        model.Details = Details;
                        model.UserID = userId;
                        db.Photos.Add(model);
                        db.SaveChanges(); 
                    }
                }
                return Content($"Total {uploadedFiles.Count} of {TagName} {Details} uploaded successfully.");
            }
            else
            {
                return Content("No files selected.");
            }
        }
        public void SaveThumbnailIcon(HttpPostedFileBase file, string savePath, int width = 64, int height = 64)
        {
            using (var original = Image.FromStream(file.InputStream))
            {
                // Create new blank image for thumbnail
                using (var thumbnail = new Bitmap(width, height))
                {
                    using (var g = Graphics.FromImage(thumbnail))
                    {
                        g.CompositingQuality = CompositingQuality.HighQuality;
                        g.SmoothingMode = SmoothingMode.HighQuality;
                        g.InterpolationMode = InterpolationMode.HighQualityBicubic;

                        // Resize the image to thumbnail
                        g.DrawImage(original, 0, 0, width, height);
                    }

                    // Save as JPEG (or PNG)
                    thumbnail.Save(savePath, ImageFormat.Jpeg);
                }
            }
        }
        public ActionResult Gallery()
        {
            string path = Server.MapPath("~/App_Data/Files");
            var files = Directory.GetFiles(path)
                                 .Select(Path.GetFileName) // Just file names
                                 .ToList();

            return View(files);
        }
        [Authorize]
        public ActionResult GetImage(string userId,string fileName)
        {

            //fileName = "style.png";
            string path = Path.Combine(Server.MapPath("~/App_Data/Files/"+ userId), fileName);

            if (!System.IO.File.Exists(path))
                return HttpNotFound();

            return File(path, "image/jpeg"); // Or detect content type dynamically
        }
    }

}